<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\Avatar\CreateAvatarRequest;
use App\Http\Resources\Avatar\AvatarResource;
use App\Models\Avatar;
use App\Services\AvatarService;
use Illuminate\Http\Request;

class AvatarController extends MainApiController
{
    protected $avatarService;
    public function __construct(AvatarService $avatarService)
    {
        $this->avatarService = $avatarService;
        parent::__construct();
    }
    public function index()
    {
        $avatars = $this->avatarService->index();
        return $this->response->success(
            AvatarResource::collection($avatars)
        );
    }

    public function store(CreateAvatarRequest $request)
    {
        $avatar = $this->avatarService->store($request);
        return $this->response->success(
            new AvatarResource($avatar)
        );
    }

    public function show($avatar_id)
    {
        $banner = $this->avatarService->show($avatar_id);
        return $this->response->success(
            new AvatarResource($banner)
        );
    }
    public function update(Request $request, Avatar $banner)
    {
        $banner = $this->avatarService->update($request, $banner);
        return $this->response->success(
            new AvatarResource($banner)
        );
    }

    public function delete(Avatar $banner)
    {
        $banner = $this->avatarService->delete($banner);
        return $this->response->success(
            ["message" => "Banner Deleted"]
        );
    }
}
