<?php

namespace App\Http\Controllers\Admin;

use App\Exceptions\NotFoundException;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\Banner\CreateBannerRequest;
use App\Http\Requests\Banner\UpdateBannerRequest;
use App\Http\Resources\Banner\BannerResource;
use App\Models\Banner;
use App\Services\BannerService;

class BannerController extends MainApiController
{
    protected $bannerService;
    public function __construct(BannerService $bannerService)
    {
        $this->bannerService = $bannerService;
        parent::__construct();
    }
    public function index()
    {
        $storeCategories = $this->bannerService->index();
        return $this->response->success(
            BannerResource::collection($storeCategories)
        );
    }

    public function store(CreateBannerRequest $request)
    {
        $storeCategory = $this->bannerService->store($request);
        return $this->response->success(
            new BannerResource($storeCategory)
        );
    }

    public function show($banner_id)
    {
        $banner = $this->bannerService->show($banner_id);
        return $this->response->success(
            new BannerResource($banner)
        );
    }
    public function update(UpdateBannerRequest $request, Banner $banner)
    {
        $banner = $this->bannerService->update($request, $banner);
        return $this->response->success(
            new BannerResource($banner)
        );
    }

    public function delete(Banner $banner)
    {
        $banner = $this->bannerService->delete($banner);
        return $this->response->success(
            ["message" => "Banner Deleted"]
        );
    }

    public function changeStatus($category_id, StoreCategory $storeCategory)
    {
        $storeCategory = $this->bannerService->changeStatus($category_id);
        return $this->response->success(
            new BannerResource($storeCategory)
        );
    }
}
