<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\MainApiController;
use App\Http\Requests\Category\AddCategoryRequest;
use App\Http\Requests\Category\UpdateCategoryRequest;
use App\Http\Resources\CategoryResource;
use App\Http\Resources\Product\ProductListResource;
use App\Http\Resources\ProductResource;
use App\Models\Category;
use App\Models\StoreCategory;
use App\Services\CategoryService;
use App\Services\ProductService;

class CategoryController extends MainApiController
{
    protected $categoryService;
    public function __construct(CategoryService $categoryService)
    {
        $this->categoryService = $categoryService;
        parent::__construct();
    }
    public function index()
    {
        $storeCategories = $this->categoryService->index();
        return $this->response->success(
            CategoryResource::collection($storeCategories)
        );
    }

    public function withoutPagination()
    {
        $storeCategories = $this->categoryService->withoutPagination();
        return $this->response->success(
            CategoryResource::collection($storeCategories)
        );
    }
    public function store(AddCategoryRequest $request)
    {
        $storeCategory = $this->categoryService->store($request);
        return $this->response->success(
            new CategoryResource($storeCategory)
        );
    }

    public function show(Category $category)
    {
        return $this->response->success(
            new CategoryResource($category)
        );
    }

    public function products(Category $category, ProductService $productService)
    {
        $products = $productService->categoryProducts($category->id);
        return $this->response->success(
            ProductListResource::collection($products)
        );
    }
    public function update(UpdateCategoryRequest $request, Category $category)
    {
        $storeCategory = $this->categoryService->update($request, $category);
        return $this->response->success(
            new CategoryResource($storeCategory)
        );
    }

    public function changeStatus($category_id)
    {
        $category = $this->categoryService->changeStatus($category_id);
        return $this->response->success(
            new CategoryResource($category)
        );
    }
}
