<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\MainApiController;
use App\Http\Requests\Commission\StoreCommissionRequest;
use App\Http\Resources\Commission\CommissionResource;
use App\Services\CommissionService;

class CommissionController extends MainApiController
{
    protected $commissionService;
    public function __construct(CommissionService $commissionService)
    {
        $this->commissionService = $commissionService;
        parent::__construct();
    }
    public function store(StoreCommissionRequest $request)
    {
        $commission = $this->commissionService->store($request);
        return $this->response->success(
            new CommissionResource($commission)
        );
    }

    public function index()
    {
        $commissions = $this->commissionService->index();
        return $this->response->success(
            CommissionResource::collection($commissions)
        );
    }
}
