<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\MainApiController;
use App\Http\Requests\DeliveryCharge\StoreDeliveryChargeRequest;
use App\Http\Resources\DeliveryCharge\DeliveryChargeResource;
use App\Services\DeliveryChargeService;

class DeliveryChargeController extends MainApiController
{
    protected $deliveryChargeService;
    public function __construct(DeliveryChargeService $deliveryChargeService)
    {
        $this->deliveryChargeService = $deliveryChargeService;
        parent::__construct();
    }
    public function store(StoreDeliveryChargeRequest $request)
    {
        $deliveryCharge = $this->deliveryChargeService->store($request);
        return $this->response->success(
            new DeliveryChargeResource($deliveryCharge)
        );
    }

    public function index()
    {
        $deliveryCharges = $this->deliveryChargeService->index();
        return $this->response->success(
            DeliveryChargeResource::collection($deliveryCharges)
        );
    }
}
