<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\Event\CreateEventRequest;
use App\Http\Requests\Event\UpdateEventRequest;
use App\Http\Resources\Event\EventResource;
use App\Models\Event;
use App\Services\EventService;

class EventController extends MainApiController
{
    protected $eventService;
    public function __construct(EventService $eventService)
    {
        $this->eventService = $eventService;
        parent::__construct();
    }
    public function index()
    {
        $storeCategories = $this->eventService->index();
        return $this->response->success(
            EventResource::collection($storeCategories)
        );
    }

    public function store(CreateEventRequest $request)
    {
        $storeCategory = $this->eventService->store($request);
        return $this->response->success(
            new EventResource($storeCategory)
        );
    }

    public function show($event_id)
    {
        $event = $this->eventService->show($event_id);
        return $this->response->success(
            new EventResource($event)
        );
    }
    public function update(UpdateEventRequest $request, Event $event)
    {
        $event = $this->eventService->update($request, $event);
        return $this->response->success(
            new EventResource($event)
        );
    }

    public function delete(Event $event)
    {
        $event = $this->eventService->delete($event);
        return $this->response->success(
            ["message" => "event Deleted"]
        );
    }
}
