<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Resources\DefaultResource;
use App\Http\Controllers\MainApiController;
use App\Models\Feedback;
use Illuminate\Support\Facades\DB;

class FeedbackController extends MainApiController
{
    public function index(Request $request)
    {
        $feedbacks = Feedback::when(request()->filled('search'), function ($q) {
            $searchTerm = request("search");
            $q->where(function ($q) use ($searchTerm) {
                $q->where('first_name', 'like', '%' . $searchTerm . '%')
                    ->orWhere('last_name', 'like', '%' . $searchTerm . '%')
                    ->orWhere('subject', 'like', '%' . $searchTerm . '%')
                    ->orWhere('email', 'like', '%' . $searchTerm . '%')
                    // Add combined first_name and last_name search
                    ->orWhere(DB::raw("CONCAT(first_name, ' ', last_name)"), 'like', '%' . $searchTerm . '%');
            });
        })
            ->when(request()->filled('type'), function ($q) {
                $q->where('type', request('type'));
            })
            ->when(request()->filled('fromDate'), function ($q) {
                $q->whereDate('created_at', '>=', request('fromDate'))
                    ->whereDate('created_at', '<=', request('toDate'));
            })
            ->orderBy('id', 'desc')
            ->paginate($this->pagination);

        return $this->response->success(
            DefaultResource::collection($feedbacks)
        );
    }

    public function show(Request $request, Feedback $feedback)
    {
        return $this->response->success(
            new DefaultResource($feedback)
        );
    }

}
