<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\Order\ChangeOrderStatusRequest;
use App\Http\Requests\StoreCategory\AddCategoryRequest;
use App\Http\Requests\StoreCategory\UpdateStoreCategoryRequest;
use App\Http\Resources\DefaultResource;
use App\Http\Resources\Order\AdminOrderResource;
use App\Http\Resources\Order\OrderDetailResource;
use App\Http\Resources\Order\StoreOrderResource;
use App\Http\Resources\Order\UserOrderResource;
use App\Http\Resources\StoreCategoryResource;
use App\Models\Order;
use App\Models\StoreCategory;
use App\Services\OrderService;

class OrderController extends MainApiController
{
    protected $orderService;
    public function __construct(OrderService $orderService)
    {
        $this->orderService = $orderService;
        parent::__construct();
    }
    public function index()
    {
        $userOrders = $this->orderService->index();
        return $this->response->success(
            AdminOrderResource::collection($userOrders)
        );
    }

    public function userOrders($id)
    {
        $userOrders = $this->orderService->userOrders($id);
        return $this->response->success(
            AdminOrderResource::collection($userOrders)
        );
    }

    public function show(OrderService $orderService, Order $order)
    {
        $order = $orderService->show($order->id);
        return $this->response->success(
            new AdminOrderResource($order)
        );
    }
    public function updateStatus(ChangeOrderStatusRequest $request)
    {
        $order = $this->orderService->changeStatus($request);
        return $this->response->success(
            new AdminOrderResource($order)
        );
    }
}
