<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Page\CreatePageRequest;
use Illuminate\Http\Request;
use App\Http\Resources\DefaultResource;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\PageUpdateRequest;
use App\Models\Page;
use Illuminate\Support\Str;

class PageController extends MainApiController
{

    public function index(Request $request)
    {
        $pages = Page::when(request()->filled('status') && request('status') != 2, function ($q) {
            $q->whereStatus(request('status'));
        })
            ->when(request()->filled('search'), function ($q) {
                $q->where(function ($q) {
                    $q->where('name', 'like', '%' . request("search") . '%');
                });
            })
            ->when(request()->filled('from'), function ($q) {
                $q->whereDate('created_at', '>=', request('from'))->whereDate('created_at', '<=', request('to'));
            })
            ->when(request()->filled('sort'), function ($q) {
                $q->where('status', '=', request('sort'));
            })
            ->orderBy('id', 'desc')
            ->paginate($this->pagination);

        return $this->response->success(
            DefaultResource::collection($pages)
        );
    }

    public function create(CreatePageRequest $request)
    {
        $page = new Page();
        $page->slug = Str::slug($request->name);
        $page->name = $request->name;
        $page->title = $request->title;
        $page->description = $request->description;
        if ($request->has('file')) {
            $saveFile = $this->saveFile($request->file, Page::IMAGES_DIRECTORY, 'local');
            $page->photo = $saveFile['fileName'];
        }
        $page->save();
        return $this->response->success(
            new DefaultResource(['page' => $page])
        );
    }


    public function show(Request $request, Page $page)
    {

        return $this->response->success(
            new DefaultResource(['page' => $page])
        );
    }

    public function showBySlug(Request $request, $slug)
    {
        $page = Page::where('slug', $slug)->first();

        return $this->response->success(
            new DefaultResource(['page' => $page])
        );
    }


    public function update(PageUpdateRequest $request, Page $page)
    {
        $page->name = $request->name;
        $page->slug = Str::slug($request->name);
        $page->title = $request->title;
        $page->description = $request->description;

        if ($request->has('file')) {
            $saveFile = $this->saveFile($request->file, Page::IMAGES_DIRECTORY, 'local');
            $page->photo = $saveFile['fileName'];
        }

        $page->save();

        return $this->response->success(
            new DefaultResource(['page' => $page])
        );
    }

    public function status(Request $request)
    {

        return $this->response->success(
            new DefaultResource(['message' => 'status method'])
        );
    }

}
