<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\Product\CreateProductRequest;
use App\Http\Requests\Product\UpdateProductRequest;
use App\Http\Resources\DefaultResource;
use App\Http\Resources\ImageResource;
use App\Http\Resources\Product\ProductListResource;
use App\Http\Resources\ProductResource;
use App\Models\Image;
use App\Models\Product;
use App\Services\ProductService;
use App\Services\StoreService;
use Illuminate\Http\Request;

class ProductController extends MainApiController
{
    private $productService;

    public function __construct(ProductService $productService)
    {
        parent::__construct();
        $this->productService = $productService;
    }
    public function index(Request $request)
    {
        $products = $this->productService->adminProducts($request);
        return $this->response->success(
            ProductListResource::collection($products)
        );
    }

    public function show(Product $product)
    {
        return $this->response->success(
            new ProductResource($product)
        );
    }

    public function changeStatus($product_id)
    {
        $product = $this->productService->changeStatus($product_id);
        return $this->response->success(
            new ProductResource($product)
        );
    }
    public function store(CreateProductRequest $request)
    {
        $product = $this->productService->store($request);
        return $this->response->success(
            new ProductResource($product)
        );
    }

    public function update(UpdateProductRequest $request, Product $product)
    {
        $product = $this->productService->update($request, $product);
        return $this->response->success(
            new ProductResource($product)
        );
    }

    public function deleteProductImage(Image $image)
    {
        $images = $this->productService->deleteProductImage($image);
        return $this->response->success(
            ImageResource::collection($images)
        );
    }

}
