<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\Question\StoreQuestionRequest;
use App\Http\Requests\Question\UpdateQuestionRequest;
use App\Http\Resources\DefaultResource;
use App\Http\Resources\Question\QuestionCategoryWiseResource;
use App\Http\Resources\Question\QuestionResource;
use App\Models\Question;
use App\Services\QuestionService;
use Illuminate\Http\Request;

class QuestionController extends MainApiController
{
    private $questionService;

    public function __construct(QuestionService $questionService)
    {
        parent::__construct();
        $this->questionService = $questionService;
    }
    public function index(Request $request)
    {
        $questions = $this->questionService->index();
        return $this->response->success(
            QuestionResource::collection($questions)
        );
    }

    public function categoryWise()
    {
        $questions = $this->questionService->categoryWise();
        return $this->response->success(
            QuestionCategoryWiseResource::collection($questions)
        );
    }

    public function preferences()
    {
        $questions = $this->questionService->preferences();
        return $this->response->success(
            new QuestionCategoryWiseResource($questions)
        );
    }

    public function optionsOfHeightCarrerFieldAndEducationlevel()
    {
        $heightOption = $this->questionService->heightOption();
        $educationLevelOption = $this->questionService->educationLevelOption();
        $carrerFieldOption = $this->questionService->carrerFieldOption();
        return $this->response->success(
            new DefaultResource([
                'height_option' => $heightOption,
                'education_level_option' => $educationLevelOption,
                'carrer_field_option' => $carrerFieldOption,
            ])
        );
    }

    public function show(Question $question)
    {
        return $this->response->success(
            new QuestionResource($question)
        );
    }
    public function store(StoreQuestionRequest $request)
    {
        $question = $this->questionService->store($request);
        return $this->response->success(
            new QuestionResource($question)
        );
    }

    public function update(UpdateQuestionRequest $request, Question $question)
    {
        $question = $this->questionService->update($request, $question);
        return $this->response->success(
            new QuestionResource($question)
        );
    }
}
