<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\Question\StoreQuestionOptionRequest;
use App\Http\Resources\Question\QuestionOptionResource;
use App\Services\QuestionOptionService;
use Illuminate\Http\Request;

class QuestionOptionController extends MainApiController
{
    private $questionOptionService;

    public function __construct(QuestionOptionService $questionOptionService)
    {
        parent::__construct();
        $this->questionOptionService = $questionOptionService;
    }

    public function store(StoreQuestionOptionRequest $request)
    {
        $questionOption = $this->questionOptionService->store($request);
        return $this->response->success(
            new QuestionOptionResource($questionOption)
        );
    }
}
