<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Resources\ReportResource;
use App\Models\Report;
use App\Services\ReportService;
use Illuminate\Http\Request;

class ReportController extends MainApiController
{
    protected $reportService;
    public function __construct(ReportService $reportService)
    {
        $this->reportService = $reportService;
        parent::__construct();
    }
    public function index()
    {
        $reports = $this->reportService->index();
        return $this->response->success(
            ReportResource::collection($reports)
        );
    }

    public function status($report)
    {
        $report = $this->reportService->changeStatus($report);
        return $this->response->success(
            new ReportResource($report)
        );
    }

    public function show(Report $report)
    {
        return $this->response->success(
            new ReportResource($report)
        );
    }
}
