<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Resources\Size\SizeResource;
use App\Services\SizeService;
use Illuminate\Http\Request;

class SizeController extends MainApiController
{
    protected $sizeService;
    public function __construct(SizeService $sizeService)
    {
        $this->sizeService = $sizeService;
        parent::__construct();
    }

    public function all()
    {
        $sizes = $this->sizeService->all();
        return $this->response->success(
            SizeResource::collection($sizes)
        );
    }
}
