<?php

namespace App\Http\Controllers\Admin;

use App\Http\Resources\User\UserProfileWithAllDataResource;
use App\Services\Admin\AdminUserService;
use App\Services\UserService;
use Illuminate\Http\Request;
use App\Http\Resources\DefaultResource;
use App\Http\Controllers\MainApiController;
use App\Http\Resources\Admin\UserListingResource;
use App\Models\User;

class UserController extends MainApiController
{
    protected $userService;
    public function __construct(UserService $userService)
    {
        $this->userService = $userService;
        parent::__construct();
    }

    public function index(Request $request)
    {
        $users = $this->userService->index();
        return $this->response->success(
            UserListingResource::collection($users)
        );
    }

    public function show(User $user)
    {
        $user = $this->userService->show($user->id);
        return $this->response->success(
            new UserProfileWithAllDataResource($user)
        );
    }

    public function status(User $user, UserService $userService)
    {
        $data = $userService->accountStatus($user->id);
        return $this->response->success(
            new UserListingResource($data)
        );
    }

    public function verificationStatus(User $user, UserService $userService)
    {
        $data = $userService->verificationStatus($user->id);
        return $this->response->success(
            new UserListingResource($data)
        );
    }

}
