<?php

namespace App\Http\Controllers\Api;


use App\Http\Requests\User\BiomatricLoginRequest;
use App\Http\Requests\User\LoginRequest;
use App\Http\Requests\User\UpdateAvatarRequest;
use App\Http\Requests\User\UpdateUserLatLongAndRadiusToHide;
use App\Http\Requests\User\UploadImageRequest;
use App\Http\Requests\User\UploadImagesRequest;
use App\Http\Requests\User\UploadSocialLinkRequest;
use App\Http\Resources\Admin\UserListingResource;
use App\Http\Resources\ImageResource;
use App\Http\Resources\User\UserProfileWithAllDataResource;
use App\Http\Resources\User\UserWithFriendResource;
use App\Models\Image;
use App\Models\Order;
use App\Models\UserLocation;
use App\Notifications\SendAdminNotification;
use App\Services\ChatService;
use App\Services\FriendService;
use Carbon\Carbon;
use DB;
use Illuminate\Http\Request;
use App\Http\Resources\DefaultResource;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\VerifyActivationCodeRequest;
use App\Http\Requests\Password\{ResetPassword, SetNewPasswordRequest, ChangePasswordRequest};
use App\Http\Requests\User\UserProfileUpdateRequest;
use App\Http\Requests\User\UserRegisterRequest;
use App\Http\Requests\User\UserSetPasswordRequest;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use App\Services\Common\UserService;

class AuthController extends MainApiController
{
    private $userService;

    public function __construct(UserService $userService)
    {
        parent::__construct();
        $this->userService = $userService;
    }

    public function dashboardStats(Request $request)
    {

        $monthlyTrend = User::selectRaw('COUNT(id) as count')->whereRaw("created_at LIKE '" . date('Y-m') . "%'")->where('type', 'user')->first();
        $totalUsers = User::where('type', 'user')->count();
        $monthlyTrend = (isset($monthlyTrend->count) && $monthlyTrend->count > 0 ? round((($monthlyTrend->count / $totalUsers) * 100), 2) : 0);
        $monthlyTrendApplication = User::selectRaw('COUNT(id) as count')->whereRaw("created_at LIKE '" . date('Y-m') . "%'")->first();
        $totalApplications = User::count();
        $monthlyTrendApplication = (isset($monthlyTrendApplication->count) && $monthlyTrendApplication->count > 0 ? round((($monthlyTrendApplication->count / $totalApplications) * 100), 2) : 0);
        $currentYear = request("year");
        // Prepare an array to hold the results
        $monthsCountUsers = array_fill(0, 12, 0); // Initialize an array with 12 zeros for each month
        $monthsCountEarnings = array_fill(0, 12, 0); // Initialize an array with 12 zeros for each month

        // Loop through each month from January to the current month
        for ($month = 1; $month <= Carbon::now()->month; $month++) {
            // Calculate the start and end dates for the current month
            $startOfMonth = Carbon::create($currentYear, $month, 1)->startOfMonth();
            $endOfMonth = Carbon::create($currentYear, $month, 1)->endOfMonth();

            // Count the number of users created in this month
            $count = User::where("type", 'user')->whereBetween('created_at', [$startOfMonth, $endOfMonth])->count();

            // Store the count in the corresponding month index (month - 1 because array index starts at 0)
            $monthsCountUsers[$month - 1] = $count;
        }
        for ($month = 1; $month <= Carbon::now()->month; $month++) {
            // Calculate the start and end dates for the current month
            $startOfMonth = Carbon::create($currentYear, $month, 1)->startOfMonth();
            $endOfMonth = Carbon::create($currentYear, $month, 1)->endOfMonth();

            // Fetch total earnings from commissions for the current month
            $totalEarnings = Order::where('is_paid', 1)->whereBetween('created_at', [$startOfMonth, $endOfMonth])
                ->get()
                ->sum(function ($order) {
                    // Calculate earnings: total_price * (commission / 100)
                    return $order->total_price * ($order->commission / 100);
                });

            // Store the total earnings in the corresponding month index
            $monthsCountEarnings[$month - 1] = $totalEarnings;
        }
        $totalEarnings = Order::where('is_paid', 1)->get()
            ->sum(function ($order) {
                // Calculate earnings: total_price * (commission / 100)
                return $order->total_price * ($order->commission / 100);
            });
        $data = [
            'status' => true,
            'total_users' => $totalUsers,
            'total_earnings' => round($totalEarnings, 2),
            'user_trend' => $monthlyTrend,
            'total_application' => $totalApplications,
            'application_trend' => $monthlyTrendApplication,
            'monthsCount' => $monthsCountUsers,
            'monthsCountEarnings' => $monthsCountEarnings,
        ];
        return $this->response->success(
            new DefaultResource(['data' => $data])
        );
    }


    public function update(UserProfileUpdateRequest $request)
    {
        auth()->user()->first_name = $request->first_name;
        auth()->user()->last_name = $request->last_name;
        auth()->user()->phone = $request->phone;
        auth()->user()->dial_code = $request->dial_code;
        auth()->user()->country_code = $request->country_code;
        // auth()->user()->gender = $request->gender;
        auth()->user()->date_of_birth = $request->date_of_birth;
        auth()->user()->age = $request->age;
        auth()->user()->height = $request->height;
        auth()->user()->education_level = $request->education_level;
        auth()->user()->career_field = $request->career_field;
        if ($request->has('avatar_id')) {
            auth()->user()->avatar_id = $request->avatar_id;
        }
        // auth()->user()->about = $request->about;
        auth()->user()->device_id = $request->device_id;
        if ($request->has('image')) {
            $saveFile = saveFile($request->image, User::IMAGES_DIRECTORY, 'local');
            auth()->user()->image = $saveFile['fileName'];
        }
        if ($request->has('images')) {
            $this->userService->uploadVerificationImages($request, auth()->user()->id);
            $admin = User::where('type', 'admin')->first();
            $body = auth()->user()->id;
            $title = auth()->user()->first_name . " " . auth()->user()->last_name . " applied for varification.";
            $data = [
                "user" => auth()->user(),
                "title" => $title,
                "body" => $body,
            ];
            $admin->notify(new SendAdminNotification($title, $body, $data));
        }
        auth()->user()->save();
        $user = User::with(['images', 'verificationimages', 'socialLinks', 'userAnswers', 'userAnswers.question.category'])->find(auth()->user()->id);
        return $this->response->success(
            new UserProfileWithAllDataResource($user)
        );
        // return response()->json(['status' => true, 'message' => 'Profile Updated Successfully', 'data' => auth()->user()]);
    }

    public function updateAvatar(Request $request)
    {
        auth()->user()->avatar_id = $request->avatar_id;
        auth()->user()->save();
        $user = User::with(['images', 'verificationimages', 'socialLinks', 'userAnswers', 'userAnswers.question.category'])->find(auth()->user()->id);
        return $this->response->success(
            new UserProfileWithAllDataResource($user)
        );
        // return response()->json(['status' => true, 'message' => 'Profile Updated Successfully', 'data' => auth()->user()]);
    }


    public function uploadImages(UploadImagesRequest $request)
    {
        $user = $this->userService->uploadImages($request);
        return $this->response->success(
            new DefaultResource(['message' => 'Images uploaded successfully!'])
        );
    }

    public function uploadSingleImage(UploadImageRequest $request)
    {
        $user = $this->userService->uploadSingleImage($request);

        $user = User::with(['images', 'verificationimages', 'socialLinks', 'userAnswers', 'userAnswers.question.category'])->find(auth()->user()->id);
        return $this->response->success(
            new UserProfileWithAllDataResource($user)
        );
    }

    public function tapProfile($id)
    {
        if (auth()->user()->id == $id) {
            $message = "You cannot add yourself to tapped profiles.";
            return $this->response->success(
                new DefaultResource(['message' => $message, 'own_profile' => true])
            );
        }
        $message = $this->userService->tapProfile($id);
        return $this->response->success(
            new DefaultResource(['message' => $message])
        );
    }

    public function removeTapProfile($id)
    {
        $messsage = $this->userService->removeTapProfile($id);
        return $this->response->success(
            new DefaultResource(['message' => $messsage])
        );
    }
    public function getTapProfiles(Request $request)
    {
        $users = $this->userService->getTapProfiles($request);
        //    id($user)
        return $this->response->success(
            UserListingResource::collection($users)
        );
    }

    public function getCountsOfChatFriendRequestAndTappedProfile(Request $request, ChatService $chatService, FriendService $friendService)
    {
        $tapProfileCount = $this->userService->getTapProfilesCount();
        $unreadChatCount = $chatService->get_unread_chats();
        $friendRequestsCount = $friendService->friendRequestsCount();
        //    id($user)
        return $this->response->success(
            new DefaultResource([
                'tap_profile_count' => $tapProfileCount,
                'unread_chat_count' => $unreadChatCount,
                'friend_requests_count' => $friendRequestsCount,
            ])
        );
    }
    public function deleteImage(Image $image)
    {
        $user = $this->userService->deleteImage($image);
        return $this->response->success(
            new DefaultResource(['message' => 'Images deleted successfully!'])
        );
    }

    public function deleteAccount(Request $request)
    {
        DB::beginTransaction();
        $user = auth()->guard()->user();
        $user->tokens()->where('id', $user->currentAccessToken()->id)->delete();
        User::find($user->id)->delete();
        DB::commit();
        return response()->json(['status' => true, 'message' => 'Account deleted']);
    }

    public function uploadSocialLinks(UploadSocialLinkRequest $request)
    {
        $user = $this->userService->uploadSocialLinks($request);
        return $this->response->success(
            new DefaultResource(['message' => 'Social media uploaded successfully!'])
        );
    }


    public function updatePassword(ChangePasswordRequest $request)
    {
        $user = $this->userService->updatePassword($request, auth()->user()->id);

        return $this->response->success(
            new DefaultResource(['message' => 'Password changed successfully!'])
        );
    }

    public function signup(UserRegisterRequest $request, UserService $userService)
    {
        $data = $userService->create($request);
        return $this->response->success(
            $data
        );
    }

    public function login(LoginRequest $request)
    {
        $data = $this->userService->checkLogin($request, 'user');
        return $this->response->success(
            $data
        );
    }

    public function loginBiomatric(BiomatricLoginRequest $request)
    {
        $data = $this->userService->checkBiometricLogin($request, 'user');
        return $this->response->success(
            $data
        );
    }

    public function reset(ResetPassword $request)
    {
        $this->userService->reset($request);
        return response()->json(['status' => true, 'message' => 'Code send to email']);
    }

    public function setPassword(UserSetPasswordRequest $request)
    {
        $this->userService->verifyAndUpdatePassword($request);
        return response()->json(['status' => true, 'message' => 'Password Changed']);
    }

    public function verifyCode(VerifyActivationCodeRequest $request)
    {
        return response()->json(['status' => true, 'message' => 'Code verified']);
    }

    public function sendVerificationCode(ResetPassword $request)
    {

        $user = $this->userService->getUserByEmail($request->email);
        $this->userService->sendAccountVerification($user);

    }

    public function logout(Request $request)
    {

        $user = Auth::user();
        $user->tokens()->where('id', $user->currentAccessToken()->id)->delete();
        return response()->json(['status' => true, 'message' => 'Logout Successful']);
    }

    public function profile(Request $request)
    {
        $user = User::with(['images', 'verificationimages', 'socialLinks', 'userAnswers', 'userAnswers.question.category'])->find(auth()->user()->id);
        return $this->response->success(
            new UserProfileWithAllDataResource($user)
        );
    }

    public function userProfile(Request $request, User $user)
    {
        return $this->response->success(
            new UserWithFriendResource($user)
        );
    }

    public function profileWithDetails($id)
    {
        $user = User::with(['images', 'verificationimages', 'socialLinks', 'userAnswers', 'userAnswers.question.category'])->find($id);
        return $this->response->success(
            new UserProfileWithAllDataResource($user)
        );
    }

    public function nfcProfileWithDetails($id)
    {
        $user = User::with(['images', 'verificationimages', 'socialLinks', 'userAnswers', 'userAnswers.question.category'])->find($id);
        return $this->response->success(
            new UserProfileWithAllDataResource($user)
        );
    }

    public function updateUserLocationAndRadius(UpdateUserLatLongAndRadiusToHide $request)
    {
        $this->userService->updateUserLocationAndRadius(
            auth()->user()->id,
            $request->latitude,
            $request->longitude,
            $request->radius
        );
        $user = User::with(['images', 'verificationimages', 'socialLinks', 'userAnswers', 'userAnswers.question.category', 'userLocation'])->find(auth()->user()->id);
        return $this->response->success(
            new UserProfileWithAllDataResource($user)
        );
    }


}
