<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Resources\Avatar\AvatarResource;
use App\Services\AvatarService;
use Illuminate\Http\Request;

class AvatarController extends MainApiController
{
    protected $avatarService;
    public function __construct(AvatarService $avatarService)
    {
        $this->avatarService = $avatarService;
        parent::__construct();
    }
    public function index()
    {
        $avatars = $this->avatarService->allAvatars();
        return $this->response->success(
            AvatarResource::collection($avatars)
        );
    }
}
