<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Resources\Banner\BannerResource;
use App\Services\BannerService;
use Illuminate\Http\Request;

class BannerController extends MainApiController
{
    protected $bannerService;
    public function __construct(BannerService $bannerService)
    {
        $this->bannerService = $bannerService;
        parent::__construct();
    }
    public function index()
    {
        $storeCategories = $this->bannerService->index();
        return $this->response->success(
            BannerResource::collection($storeCategories)
        );
    }
}
