<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\Cart\AddProductToCartRequest;
use App\Http\Requests\Cart\UpdateCartItemRequest;
use App\Http\Resources\CartResource;
use App\Http\Resources\DefaultResource;
use App\Models\Cart;
use App\Services\CartService;
use App\Services\ProductService;
use Illuminate\Http\Request;
use Illuminate\Auth\AuthenticationException;


class CartController extends MainApiController
{
    protected $cartService;
    public function __construct(CartService $cartService)
    {
        $this->cartService = $cartService;
        parent::__construct();
    }
    public function store(AddProductToCartRequest $request, ProductService $productService)
    {
        $checkCartItem = $this->cartService->checkCartItem($request->product_id, $request->user_id);
        $product = $productService->show($request->product_id);
        if ($checkCartItem) {
            $cartItem = $this->cartService->update($checkCartItem->quantity + 1, $checkCartItem);

        } else {
            $cartItem = $this->cartService->store($product, $request->quantity, $request->size_id, $request->user_id);
        }

        return $this->response->success(
            new CartResource($cartItem)
        );
    }

    public function show()
    {
        $cart = $this->cartService->index();
        return $this->response->success(
            CartResource::collection($cart)
        );
    }

    public function delete(Cart $cart)
    {
        $this->cartService->delete($cart);
        return $this->response->success(
            new DefaultResource(['message' => "Item Removed"])
        );
    }

    public function update(UpdateCartItemRequest $request, Cart $cart)
    {
        $this->cartService->update($request->quantity, $cart);
        return $this->response->success(
            new CartResource($cart)
        );
    }
    public function updatebyProductId(UpdateCartItemRequest $request, )
    {
        $cart = $this->cartService->updateByProductId($request);
        return $this->response->success(
            new CartResource($cart)
        );
    }
}
