<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\MainApiController;
use App\Http\Resources\CategoryResource;
use App\Services\CategoryService;


class CategoryController extends MainApiController
{
    protected $categoryService;
    public function __construct(CategoryService $categoryService)
    {
        $this->categoryService = $categoryService;
        parent::__construct();
    }
    public function all()
    {
        $storeCategories = $this->categoryService->all();
        return $this->response->success(
            CategoryResource::collection($storeCategories)
        );
    }
}
