<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\Chat\CreateChatRequest;
use App\Http\Requests\Chat\CreateGroupChatRequest;
use App\Http\Requests\Chat\SendMessageRequest;
use App\Http\Resources\Chat\ChatResource;
use App\Http\Resources\Chat\MessageResource;
use App\Http\Resources\DefaultResource;
use App\Services\ChatService;
use Illuminate\Http\Request;

class ChatController extends MainApiController
{
    protected $chatService;
    public function __construct(ChatService $chatService)
    {
        $this->chatService = $chatService;
        parent::__construct();
    }


    public function get_unread_chats()
    {
        $response = $this->chatService->get_unread_chats();
        return $this->response->success(
            new DefaultResource(['count' => $response])
        );
    }
    public function createChat(CreateChatRequest $request)
    {
        $response = $this->chatService->createChat($request);
        return $this->response->success(
            new ChatResource($response)
        );
    }

    public function createGroup(CreateGroupChatRequest $request)
    {
        $response = $this->chatService->createGroup($request);
        return $this->response->success(
            new ChatResource($response)
        );
    }

    public function leaveGroup($id)
    {
        $response = $this->chatService->leaveGroup($id);
        return $this->response->success(
            new DefaultResource(['message' => $response])

        );
    }

    public function get_chat_list(Request $request)
    {
        $response = $this->chatService->get_chat_list($request);
        return $this->response->success(
            ChatResource::collection($response)
        );
    }

    public function get_chat($id)
    {
        $response = $this->chatService->get_chat($id);
        return $this->response->success(
            MessageResource::collection($response)
        );
    }

    public function send_message(SendMessageRequest $request)
    {
        $response = $this->chatService->send_message($request);
        return $this->response->success(
            new MessageResource($response)
        );
    }
}
