<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Resources\DeliveryCharge\DeliveryChargeResource;
use App\Services\DeliveryChargeService;
use Illuminate\Http\Request;

class DeliveryChargeController extends MainApiController
{
    protected $deliveryChargeService;
    public function __construct(DeliveryChargeService $deliveryChargeService)
    {
        $this->deliveryChargeService = $deliveryChargeService;
        parent::__construct();
    }
    public function index()
    {
        $deliveryCharge = $this->deliveryChargeService->currentDeliveryCharges();
        return $this->response->success(
            new DeliveryChargeResource($deliveryCharge)
        );
    }
}
