<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Resources\Event\EventResource;
use App\Services\EventService;
use Illuminate\Http\Request;

class EventController extends MainApiController
{
    protected $eventService;
    public function __construct(EventService $eventService)
    {
        $this->eventService = $eventService;
        parent::__construct();
    }
    public function index()
    {
        $events = $this->eventService->index();
        return $this->response->success(
            EventResource::collection($events)
        );
    }
}
