<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Resources\DefaultResource;
use App\Http\Controllers\MainApiController;
use App\Models\Feedback;

class FeedbackController extends MainApiController
{
    public function store(Request $request)
    {
        $feedback = Feedback::create([
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'phone' => $request->phone,
            'subject' => $request->subject,
            'message' => $request->message,
            'type' => $request->user_id ? Feedback::TYPE_USER : Feedback::TYPE_GUEST,
        ]);
        $title = $request->first_name . " " . $request->last_name . " submited query !";
        $body = $request->subject;
        $data = [
            "user" => $request->all(),
            "title" => $title,
            "body" => $body,
        ];
        sendNotificationToAdmin($title, $body, $data);
        return $this->response->success(
            new DefaultResource($feedback)
        );
    }


    public function show(Request $request, Feedback $feedback)
    {
        $feedback = $feedback->load('user');
        return $this->response->success(
            new DefaultResource(['feedback' => $feedback])
        );
    }

}
