<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Resources\Admin\UserListingResource;
use App\Http\Resources\DefaultResource;
use App\Http\Resources\Friend\FriendRequestResource;
use App\Services\ChatService;
use App\Services\FriendService;
use Illuminate\Http\Request;

class FriendController extends MainApiController
{
    protected $friendService;
    public function __construct(FriendService $friendService)
    {
        $this->friendService = $friendService;
        parent::__construct();
    }


    public function sendRequest($receiverId)
    {
        $response = $this->friendService->sendRequest($receiverId);
        return $this->response->success(
            new DefaultResource(['message' => $response])
        );
    }

    public function AddToCancelledUsers($receiverId)
    {
        $check = $this->friendService->checkIfAlreadyInCancelledRequests($receiverId);
        if (!$check) {
            $check = $this->friendService->addToCancelledUsers($receiverId);
        }
        $check = $this->friendService->updateCancelledUserCreatedAtTime($check->id);
        return $this->response->success(
            new DefaultResource(['message' => "Added To Cancelled Users"])
        );
    }

    public function getDailyFriendRequestCount()
    {
        $response = $this->friendService->getDailyFriendRequestCount();
        return $this->response->success(
            new DefaultResource(['count' => $response])
        );
    }

    public function acceptRequest($requestId, ChatService $chatService)
    {
        $response = $this->friendService->acceptRequest($requestId, $chatService);
        return $this->response->success(
            new DefaultResource(['message' => $response])
        );
    }
    public function rejectRequest($requestId)
    {
        $response = $this->friendService->rejectRequest($requestId);
        return $this->response->success(
            new DefaultResource(['message' => $response])
        );
    }

    public function cancelRequest($userId)
    {
        $response = $this->friendService->cancelRequest($userId);
        return $this->response->success(
            new DefaultResource(['message' => $response])
        );
    }
    public function getFriendsList()
    {
        $response = $this->friendService->getFriendsList();
        return $this->response->success(
            UserListingResource::collection($response)
        );
    }
    public function friendRequests()
    {
        $response = $this->friendService->friendRequests();
        return $this->response->success(
            FriendRequestResource::collection($response)
        );
    }
    public function friendRequestsCount()
    {
        $response = $this->friendService->friendRequestsCount();
        return $this->response->success(
            new DefaultResource(['count' => $response])
        );
    }
    public function unFriend($id)
    {
        $response = $this->friendService->unFriend($id);
        return $this->response->success(
            new DefaultResource(['message' => $response])

        );
    }


}
