<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\Order\ChangeOrderStatusRequest;
use App\Http\Requests\Order\CreateOrderRequest;
use App\Http\Resources\DefaultResource;
use App\Http\Resources\Order\StoreOrderResource;
use App\Http\Resources\Order\UserOrderResource;
use App\Http\Resources\OrderResource;
use App\Models\Order;
use App\Models\Store;
use App\Services\OrderService;
use App\Services\StripeService;
use Illuminate\Http\Request;

class OrderController extends MainApiController
{
    public function index(OrderService $orderService)
    {
        $orders = $orderService->userOrders(auth()->user()->id);
        return $this->response->success(
            UserOrderResource::collection($orders)
        );
    }
    public function store(CreateOrderRequest $request, OrderService $orderService, StripeService $stripeService)
    {
        $stripeCheckoutSession = $orderService->store($request, $stripeService);
        return $this->response->success(
            new DefaultResource($stripeCheckoutSession)
        );
    }

    public function show(OrderService $orderService, Order $order)
    {
        $order = $orderService->show($order->id);
        return $this->response->success(
            new UserOrderResource($order)
        );
    }

    public function userOrders(OrderService $orderService)
    {
        $userOrders = $orderService->userOrders(auth()->user()->id);
        return $this->response->success(
            UserOrderResource::collection($userOrders)
        );
    }

    public function storeOrders(Store $store, OrderService $orderService)
    {
        $storeOrders = $orderService->storeOrders($store->id);
        return $this->response->success(
            StoreOrderResource::collection($storeOrders)
        );
    }

    public function changeStoreStatus(Store $store, ChangeOrderStatusRequest $request, OrderService $orderService)
    {
        $orderService->ChangeStoreStatus($request, $store->id);
        return $this->response->successMessage(
            "Order status has been changed"
        );
    }
}
