<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\User\AddUserPreferenceRequest;
use App\Http\Resources\Admin\UserListingResource;
use App\Http\Resources\DefaultResource;
use App\Http\Resources\Question\PreferenceResource;
use App\Http\Resources\User\MapUserListingResource;
use App\Http\Resources\User\UserProfileWithAllDataResource;
use App\Models\User;
use App\Models\UserPreference;
use App\Services\PreferenceService;
use Illuminate\Http\Request;

class PreferenceController extends MainApiController
{
    private $preferenceService;

    public function __construct(PreferenceService $preferenceService)
    {
        parent::__construct();
        $this->preferenceService = $preferenceService;
    }
    public function store(AddUserPreferenceRequest $request)
    {
        $user = $this->preferenceService->store($request);
        $user = User::with(['images', 'verificationimages', 'socialLinks', 'userAnswers', 'userAnswers.question.category'])->find($user->id);
        // $user = User::with(['preferences.questionOptions'])->find($user->id);

        return $this->response->success(
            new UserProfileWithAllDataResource($user)
        );
    }

    public function getProfiles(Request $request)
    {
        $users = $this->preferenceService->getMatchedProfiles($request);

        return $this->response->success(
            UserListingResource::collection($users)
        );
    }

    public function getProfilesWithFilters(Request $request)
    {

        $users = $this->preferenceService->getMatchedProfilesWithFilters($request);

        return $this->response->success(
            MapUserListingResource::collection($users)
        );
    }

    public function getTopProfiles()
    {
        $users = $this->preferenceService->getTopMatchedProfiles();

        return $this->response->success(
            UserListingResource::collection($users)
        );
    }


}
