<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Resources\Product\ProductListResource;
use App\Http\Resources\ProductResource;
use App\Models\Product;
use App\Services\ProductService;
use Illuminate\Http\Request;

class ProductController extends MainApiController
{
    private $productService;

    public function __construct(ProductService $productService)
    {
        parent::__construct();
        $this->productService = $productService;
    }
    public function index(Request $request)
    {
        $products = $this->productService->index();
        return $this->response->success(
            ProductResource::collection($products)
        );
    }

    public function productsByCategory($id)
    {
        $products = $this->productService->byCategory($id);
        return $this->response->success(
            ProductResource::collection($products)
        );

    }

    public function show(Product $product)
    {
        return $this->response->success(
            new ProductResource($product)
        );
    }
}
