<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\Wishlist\AddProductToWishlistRequest;
use App\Http\Resources\WishlistResource;
use App\Services\RecentlyViewedProductService;
use Illuminate\Http\Request;

class RecentlyViewedProductController extends MainApiController
{
    private $recentlyViewedProductService;

    public function __construct(RecentlyViewedProductService $recentlyViewedProductService)
    {
        parent::__construct();
        $this->recentlyViewedProductService = $recentlyViewedProductService;
    }
    public function index()
    {
        $recentlyViewedProducts = $this->recentlyViewedProductService->index();
        return $this->response->success(
            WishlistResource::collection($recentlyViewedProducts)
        );
    }
    public function store(AddProductToWishlistRequest $request)
    {
        $recentlyViewedProduct = $this->recentlyViewedProductService->store($request->product_id);
        return $this->response->success(
            new WishlistResource($recentlyViewedProduct)
        );
    }
}
