<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\Store\CreateStoreRequest;
use App\Http\Requests\Store\UpdateStoreRequest;
use App\Http\Resources\DefaultResource;
use App\Http\Resources\StoreResource;
use App\Models\Store;
use App\Services\StoreService;
use Illuminate\Http\Request;

class StoreController extends MainApiController
{
    public function index(StoreService $storeService)
    {
        $stores = $storeService->index();
        return $this->response->success(
            StoreResource::collection($stores)
        );
    }
    public function store(CreateStoreRequest $request, StoreService $storeService)
    {
        $checkStore = $storeService->checkStoreExists();
        if (!$checkStore) {
            $store = $storeService->store($request);
            return $this->response->success(
                new StoreResource($store)
            );
        }
        return $this->response->fail(
            new DefaultResource(['message' => "Can't Create Store! Store Already Created And Status Is Active"])
        );
    }

    public function update(UpdateStoreRequest $request, Store $store, StoreService $storeService)
    {
        $checkStore = $storeService->checkStoreExists();
        if ($checkStore) {
            $store = $storeService->update($request, $store);
            return $this->response->success(
                new StoreResource($store)
            );
        }
        return $this->response->fail(
            new DefaultResource(['message' => "Can't Update Store! Store Please Activate To Update"])
        );
    }

    public function show(Store $store)
    {
        return $this->response->success(
            new StoreResource($store)
        );
    }

    public function ChangeStatus($id, Request $request, StoreService $storeService)
    {
        $checkStore = $storeService->checkStoreExists();
        if ($checkStore && $request->status === Store::ACTIVE) {
            return $this->response->fail(
                new DefaultResource(['message' => "Can't Change Status!"])
            );
        }
        $store = $storeService->ChangeStatus($id, $request->status);
        return $this->response->success(
            new StoreResource($store)
        );
    }

    public function userStores(StoreService $storeService)
    {
        $stores = $storeService->userStores();
        return $this->response->success(
            StoreResource::collection($stores)
        );
    }
}
