<?php

namespace App\Http\Controllers\Api;


use App\Http\Controllers\MainApiController;
use App\Http\Requests\User\AddBioMetricKeyRequest;
use App\Http\Requests\User\UpdateLocationRequest;
use App\Http\Requests\User\UpdateNfcTagRequest;
use App\Http\Resources\Admin\UserListingResource;
use App\Http\Resources\DefaultResource;
use App\Services\Common\UserService;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;
class UserController extends MainApiController
{
    protected $userService;
    public function __construct(UserService $userService)
    {
        $this->userService = $userService;
        parent::__construct();
    }
    public function changeLocation()
    {
        $user = $this->userService->changeStatusOfAProperty(auth()->user()->id, 'is_location_enable');
        return $this->response->success(
            new UserListingResource($user)
        );
    }

    public function updateLocation(UpdateLocationRequest $request)
    {
        $user = $this->userService->updateLocation($request->user_id, $request);
        return $this->response->success(
            new UserListingResource($user)
        );
    }
    public function changeLiveStatus()
    {
        $user = $this->userService->changeStatusOfAProperty(auth()->user()->id, 'live_location');
        return $this->response->success(
            new UserListingResource($user)
        );
    }
    public function updateNfc(UpdateNfcTagRequest $request)
    {
        $user = $this->userService->updateNfc(auth()->user()->id, $request);
        return $this->response->success(
            new DefaultResource(["url" => $user])
        );
    }
    public function changeLastActiveStatus()
    {
        $user = $this->userService->changeStatusOfAProperty(auth()->user()->id, 'last_active');
        return $this->response->success(
            new UserListingResource($user)
        );
    }
    public function changePinPointStatus(Request $request)
    {
        $user = $this->userService->changeStatusOfAProperty(auth()->user()->id, 'pin_point');
        $user = $this->userService->updatePinpointLocation(auth()->user()->id, $request->pintpont_longitude, $request->pintpont_latitude);
        return $this->response->success(
            new UserListingResource($user)
        );
    }


    public function addBiometricKey(AddBioMetricKeyRequest $request)
    {
        if ($this->userService->checkPassword(request: $request)) {
            throw ValidationException::withMessages([
                'password' => ["Incorrect Password"],
            ]);
        }
        $this->userService->updateFaceId($request);
        return $this->response->successMessage('Successfully updated');
    }

    public function disableBiometric()
    {
        $this->userService->disableFaceId();
        return $this->response->successMessage('Successfully updated');
    }


}
