<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\Cart\AddProductToCartRequest;
use App\Http\Requests\Wishlist\AddProductToWishlistRequest;
use App\Http\Resources\DefaultResource;
use App\Http\Resources\WishlistResource;
use App\Models\Wishlist;
use App\Services\WishlistService;
use Illuminate\Auth\AuthenticationException;
use Illuminate\Http\Request;

class WishListController extends MainApiController
{
    public function store(AddProductToWishlistRequest $request, WishlistService $wishlistService)
    {
        $checkWishlistItem = $wishlistService->checkWishlistItem($request->product_id);
        if ($checkWishlistItem) {
            throw new AuthenticationException(
                "Item already added to wishlist!"
            );
        }
        $wishlistItem = $wishlistService->store($request->product_id);
        return $this->response->success(
            new WishlistResource($wishlistItem)
        );
    }

    public function show(WishlistService $wishlistService)
    {
        $wishlist = $wishlistService->index();
        return $this->response->success(
            WishlistResource::collection($wishlist)
        );
    }

    public function delete(Wishlist $wishlist, WishlistService $wishlistService)
    {
        $wishlistService->delete($wishlist);
        return $this->response->success(
            new DefaultResource(['message' => "Item Removed"])
        );
    }
}
