<?php

namespace App\Http\Controllers;

use App\Http\Controllers\MainApiController;
use App\Http\Resources\NotificationResource;
use App\Models\User;
use App\Services\FirebaseService;
use Illuminate\Http\Request;
use App\Services\NotificationService;
use Log;


class NotificationController extends MainApiController
{
    public function index(NotificationService $notificationService)
    {
        $data = $notificationService->index();
        return $this->response->success(
            $data
        );
    }

    public function mark(Request $request, NotificationService $notificationService)
    {
        $data = $notificationService->mark();
        return $this->response->success(
            $data
        );
    }

    public function unread(NotificationService $notificationService)
    {
        $data = $notificationService->unread();
        return $this->response->success(
            $data
        );
    }
    public function read(NotificationService $notificationService)
    {
        $data = $notificationService->read();
        return $this->response->success(
            $data
        );
    }

    public function markAsUnread(Request $request)
    {
        $notification = auth()->user()->notifications()->where('id', $request->uuid)->get();
        return $notification->markAsUnread();
    }

    public function individual(Request $request)
    {
        $notification = auth()->user()->notifications()->where('id', $request->uuid)->get();
        $notification->markAsRead();
        return $this->response->success(
            NotificationResource::collection(
                $notification
            )
        );

    }

    public function unreadNotificationCount()
    {
        return response()->json(["count" => auth()->user()->unreadNotifications()->count()], 200);
    }

    public function unreadMessageCount()
    {
        return response()->json(["count" => auth()->user()->unreadNotifications()->whereRaw('JSON_CONTAINS(`data`, \'{"data": {"type": "message"}}\')')->count()], 200);
    }

    public function sendFirebaseNotification(Request $request)
    {
        $user = User::find($request->user_id);
        $msg = $user->first_name . " " . $user->last_name . " is in your 500-foot radius.";

        // Log::info('User in radius: ' . print_r($request->userInRadius, true));

        // Retrieve device tokens and filter out null values
        // $tokens = User::whereIn('id', $request->userInRadius)
        //     ->whereNotIn('id', [$user->id]) // Ensure the user is not included in the notification
        //     ->pluck('device_token')
        //     ->filter() // Remove null values
        //     ->toArray();
        $tokens = [$user->device_token];
        
        // Log the tokens for debugging
        // Log::info ('Filtered device tokens: ' . print_r($tokens, true));

        // Check if there are valid tokens
        if (count($tokens) > 0) {
        
            $firebase = new FirebaseService();
            $firebase->sendMultipleNotification($tokens, "Bandad Location Alert", $msg);
        } else {
            Log::warning('No valid device tokens found for users in radius.');
        }

        return response()->json(['message' => 'Notification sent successfully']);
    }
}
