<?php

namespace App\Http\Requests\Banner;

use Illuminate\Foundation\Http\FormRequest;

class UpdateBannerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'title' => 'required|string',
            'expiry_date' => 'required|date|after:today',
            'image' => 'nullable|mimes:jpeg,png|max:10240', // Optional image, should be jpeg or png, max 2MB
        ];
    }

    public function messages(): array
    {
        return [
            'title.required' => 'The title field is required.',
            'title.string' => 'The title must be a string.',
            'expiry_date.required' => 'The expiry date field is required.',
            'expiry_date.date' => 'The expiry date must be a valid date.',
            'expiry_date.after' => 'The expiry date must be a date after today.',
            'image.mimes' => 'The image must be a file of type: jpeg, png.',
            'image.max' => 'The image size may not be greater than 2MB.',
        ];
    }
}
