<?php

namespace App\Http\Requests\Cart;

use App\Models\Product;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateCartItemRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'product_id' => [
                'required',
                Rule::exists('products', 'id'),
            ],
            'quantity' => [
                'required',
                'numeric',
                'min:1', // Quantity must be at least 1
                function ($attribute, $value, $fail) {
                    $product = Product::find($this->input('product_id'));

                    if (!$product) {
                        $fail('The selected product is invalid.');
                        return;
                    }

                    if ($value > $product->quantity) {
                        $fail('The quantity requested exceeds the available quantity.');
                    }
                },
            ],
        ];
    }
}
