<?php

namespace App\Http\Requests\Event;

use Illuminate\Foundation\Http\FormRequest;

class UpdateEventRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|string',
            'address' => 'required|string',
            'date' => 'required|date|after:today',
            'image' => 'nullable|mimes:jpeg,png|max:10240', // Optional image, should be jpeg or png, max 2MB
        ];
    }

    public function messages(): array
    {
        return [
            'name.required' => 'The name field is required.',
            'name.string' => 'The name must be a string.',
            'address.required' => 'The address field is required.',
            'address.string' => 'The address must be a string.',
            'date.required' => 'The expiry date field is required.',
            'date.date' => 'The expiry date must be a valid date.',
            'date.after' => 'The expiry date must be a date after today.',
            'image.mimes' => 'The image must be a file of type: jpeg, png.',
            'image.max' => 'The image size may not be greater than 2MB.',
        ];
    }
}
