<?php

namespace App\Http\Requests\Order;

use App\Models\Order;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ChangeOrderStatusRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'order_id' => [
                'required',
                Rule::exists('orders', 'id'),
            ],
            'status' => [
                'required',
                'in:' . Order::ACCEPTED . ',' . Order::PENDING . ',' . Order::PROCESSED . ',' . Order::DELIVERED . ',' . Order::REJECTED . ',' . Order::CANCELLED,
            ],
            'reason' => [
                'required_if:status,' . Order::CANCELLED, // Require reason when status is CANCELLED
            ],
        ];
    }
}
