<?php

namespace App\Http\Requests\Order;

use Illuminate\Foundation\Http\FormRequest;

class CreateOrderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'contactInfo.first_name' => 'required|string|max:255',
            'contactInfo.last_name' => 'required|string|max:255',
            'contactInfo.email' => 'required|email|max:255',
            'contactInfo.phone' => 'required|string|max:20',
            'shippingAddress.first_name' => 'required|string|max:255',
            'shippingAddress.last_name' => 'required|string|max:255',
            'shippingAddress.address' => 'required|string|max:255',
            'shippingAddress.phone' => 'required|string|max:20',
            'shippingAddress.country' => 'required|string|max:255',
            'shippingAddress.city' => 'required|string|max:255',
            'shippingAddress.state' => 'required|string|max:255',
            'shippingAddress.zip_code' => 'required|string|max:20',
            'billingAddress.first_name' => 'required|string|max:255',
            'billingAddress.last_name' => 'required|string|max:255',
            'billingAddress.address' => 'required|string|max:255',
            'billingAddress.phone' => 'required|string|max:20',
            'billingAddress.country' => 'required|string|max:255',
            'billingAddress.city' => 'required|string|max:255',
            'billingAddress.state' => 'required|string|max:255',
            'billingAddress.zip_code' => 'required|string|max:20',
        ];
    }
}
