<?php

namespace App\Http\Requests\User;

use Illuminate\Foundation\Http\FormRequest;

class AddUserPreferenceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'preferences' => 'nullable|array', // Making preferences optional
            'preferences.*.question_id' => 'nullable|exists:questions,id', // Making question_id optional
            'preferences.*.answer_ids' => 'nullable|array', // Making answer_ids optional
            'preferences.*.answer_ids.*' => 'nullable|exists:question_options,id', // Making each answer ID optional
        ];
    }
}
