<?php

namespace App\Http\Requests\User;

use Illuminate\Foundation\Http\FormRequest;

class UpdateUserLatLongAndRadiusToHide extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'latitude' => 'required|numeric|between:-90,90',  // Latitude must be numeric and between -90 and 90
            'longitude' => 'required|numeric|between:-180,180',  // Longitude must be numeric and between -180 and 180
            'radius' => 'required|numeric|min:0',  // Radius must be numeric and non-negative
        ];
    }
}
