<?php
namespace App\Http\Requests\User;

use Illuminate\Foundation\Http\FormRequest;

class UploadImagesRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'images' => 'nullable|array', // Makes the 'images' field optional, but if present, it must be an array
            'images.*' => 'image|mimes:jpeg,png,jpg,gif|max:50360', // Validates each file if 'images' is provided
        ];
    }

    /**
     * Custom messages for validation.
     *
     * @return array<string, string>
     */
    public function messages(): array
    {
        return [
            'images.array' => 'The images field must be an array.',
            'images.*.image' => 'Each file must be an image.',
            'images.*.mimes' => 'Each image must be a file of type: jpeg, png, jpg, gif.',
            'images.*.max' => 'Each image must not be greater than 49MB.',  // Adjusted to 15MB as per your max size (15360 KB)
        ];
    }
}
