<?php
namespace App\Http\Requests\User;

use Illuminate\Foundation\Http\FormRequest;

class UploadSocialLinkRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'social_links' => 'nullable|array',  // If present, it should be an array, otherwise it's ignored
            'social_links.*.link' => 'nullable|url',  // If 'link' is present, it should be a valid URL
            'social_links.*.type' => 'nullable|in:facebook,instagram,linkedin,quora,reddit,snapchat,tiktok,twitter',  // If 'type' is present, it should be one of the valid types
        ];
    }

    /**
     * Custom messages for validation errors.
     *
     * @return array
     */
    public function messages(): array
    {
        return [
            'social_links.*.link.url' => 'Each social link URL must be a valid URL.',
            'social_links.*.type.in' => 'The social link type must be one of: facebook, instagram, linkedin, quora, reddit, snapchat, tiktok, twitter.',
        ];
    }
}
