<?php

namespace App\Http\Resources\Admin\Store;

use App\Http\Resources\Admin\UserListingResource;
use App\Http\Resources\ImageResource;
use App\Http\Resources\ProductResource;
use App\Http\Resources\StoreCategoryResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class StoreWithProductsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'status' => $this->status,
            'is_blocked' => $this->is_blocked,
            'description' => $this->description,
            'image' => new ImageResource($this->image),
            'category' => new StoreCategoryResource($this->category),
            'user' => new UserListingResource($this->user),
            'products' => ProductResource::collection($this->products),
            'updated_at' => $this->updated_at,
            'created_at' => $this->created_at,
        ];
    }
}
