<?php

namespace App\Http\Resources\Avatar;

use App\Http\Resources\ImageResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AvatarResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'type' => $this->type,
            'image' => new ImageResource($this->image),
            'updated_at' => $this->updated_at,
            'created_at' => $this->created_at,
        ];
    }
}
