<?php

namespace App\Http\Resources;

use App\Http\Resources\Size\SizeResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CartResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'quantity' => $this->quantity,
            'price' => $this->price,
            'total' => $this->quantity * $this->price,
            'product' => new ProductResource($this->product),
            'size' => new SizeResource($this->size),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
