<?php

namespace App\Http\Resources\Chat;

use App\Helpers\Constant;
use App\Models\Chat;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ChatResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $currentUser = null;
        if ($this->type === Chat::PRIVATE ) {
            $currentUser = $this->users->where('id', '!=', auth()->id())->first();
        }
        return [
            'id' => $this->id,
            'type' => $this->type,
            'name' => $this->when(
                $this->type === Chat::PRIVATE ,
                fn() => $currentUser?->full_name,
                $this->name
            ),
            'image' => $this->when(
                $this->type === Chat::PRIVATE ,
                fn() => $currentUser?->image,
                $this->image
            ),
            'user_id' => $this->when(
                $this->type === Chat::PRIVATE ,
                fn() => $currentUser?->id,
                null
            ),

            'unread' => $this->messages()->whereNull('read_at')->whereNot('user_id', auth()->id())->count(),
            'last_message' => new MessageResource($this->messages->last()),
        ];
    }

}
