<?php

namespace App\Http\Resources\Chat;

use App\Http\Resources\ImageResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MessageResource extends JsonResource
{
    /**


    Transform the resource into an array.*
        @return array<string, mixed>*/
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'chat_id' => $this->chat_id,
            'user_id' => $this->user_id,
            'user_name' => $this->user?->first_name . " " . $this->user?->last_name,
            'image' => $this->user?->image,
            'message' => $this->message,
            'read_at' => $this->read_at,
            'date' => $this->created_at->format('Y-m-d'),
            'time' => $this->created_at->format('H:i'),
            'file' => new ImageResource($this->image),
            'readable_time' => $this->created_at->diffForHumans(),
            // 'readable_time' => $this->created_at->diffForHumans(),
        ];
    }

}
