<?php

namespace App\Http\Resources\Event;

use App\Http\Resources\ImageResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EventResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'date' => $this->date,
            'address' => $this->address,
            'updated_at' => $this->updated_at,
            'created_at' => $this->created_at,
            'image' => new ImageResource($this->image),
        ];
    }
}
