<?php

namespace App\Http\Resources\Order;

use App\Http\Resources\Admin\UserListingResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AdminOrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'total_price' => $this->total_price,
            'total_quantity' => $this->total_quantity,
            'status' => $this->status,
            'address' => $this->address,
            'delivery_charges' => $this->delivery_charges,
            'rejection_reason' => $this->rejection_reason,
            'details' => OrderDetailResource::collection($this->details),
            'user' => new UserListingResource($this->user),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
