<?php

namespace App\Http\Resources\User;

use App\Http\Resources\Avatar\AvatarResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MapUserListingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'full_name' => $this->full_name,
            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'email' => $this->email,
            'phone' => $this->phone,
            'dial_code' => $this->dial_code,
            'image_url' => $this->image_url,
            'status' => $this->status,
            'ring' => $this->ring,
            'gender' => $this->gender,
            'height' => $this->height,
            'education_level' => $this->education_level,
            'career_field' => $this->career_field,
            'type' => $this->type,
            'country_code' => $this->country_code,
            'age' => $this->age,
            'about' => $this->about,
            'date_of_birth' => $this->date_of_birth,
            'device_id' => $this->device_id,
            'device_token' => $this->device_token,
            'is_location_enable' => $this->is_location_enable,
            'live_location' => $this->live_location,
            'last_active' => $this->last_active,
            'pin_point' => $this->pin_point,
            'pintpont_longitude' => $this->pintpont_longitude,
            'pintpont_latitude' => $this->pintpont_latitude,
            'longitude' => $this->longitude,
            'latitude' => $this->latitude,
            'address' => $this->address,
            'is_complete' => $this->is_complete,
            'nfc_tag' => $this->nfc_tag,
            'distance' => $this->distance,
            'created_at' => $this->created_at,
            'hide_locations' => $this->userLocation,
            'avatar' => new AvatarResource($this->avatar)
        ];
    }
}
